/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tiviacz.travelersbackpack.util.RenderUtils;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FluidModelPart
extends ModelPart {
    private final FluidTank leftTank = this.createFluidHandler(1);
    private final FluidTank rightTank = this.createFluidHandler(1);
    private MultiBufferSource buffer;

    public FluidModelPart(ModelPart parent) {
        super(parent.f_104212_, parent.f_104213_);
    }

    public void prepare(ItemStack stack, MultiBufferSource buffer) {
        if (stack.m_41782_()) {
            if (stack.m_41783_().m_128441_("LeftTank")) {
                this.leftTank.readFromNBT(stack.m_41783_().m_128469_("LeftTank"));
            } else if (!this.leftTank.isEmpty()) {
                this.leftTank.setFluid(FluidStack.EMPTY);
            }
            if (stack.m_41783_().m_128441_("RightTank")) {
                this.rightTank.readFromNBT(stack.m_41783_().m_128469_("RightTank"));
            } else if (!this.rightTank.isEmpty()) {
                this.rightTank.setFluid(FluidStack.EMPTY);
            }
        }
        this.buffer = buffer;
    }

    public void m_104301_(PoseStack pPoseStack, VertexConsumer pVertexConsumer, int pPackedLight, int pPackedOverlay) {
        if (this.buffer == null) {
            return;
        }
        pPoseStack.m_85836_();
        this.m_104299_(pPoseStack);
        this.render(pPoseStack, this.buffer, pPackedLight);
        pPoseStack.m_85849_();
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int combinedLight) {
        poseStack.m_85836_();
        poseStack.m_85841_(1.0f, 1.05f, 1.0f);
        RenderUtils.renderFluidInTank(null, this.leftTank, poseStack, buffer, combinedLight, -0.66f, -0.55f, -0.235f);
        RenderUtils.renderFluidInTank(null, this.rightTank, poseStack, buffer, combinedLight, 0.24f, -0.55f, -0.235f);
        poseStack.m_85849_();
    }

    private FluidTank createFluidHandler(int capacity) {
        return new FluidTank(capacity){

            public FluidTank readFromNBT(CompoundTag nbt) {
                this.setCapacity(nbt.m_128425_("Capacity", 3) ? nbt.m_128451_("Capacity") : 1000);
                FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)nbt);
                this.setFluid(fluid);
                return this;
            }
        };
    }
}

